/*
 *      Interactive disassembler (IDA).
 *      Version 2.05
 *      Copyright (c) 1990-93 by Ilfak Guilfanov. (2:5020/209@fidonet)
 *      ALL RIGHTS RESERVED.
 *
 */

#include "intel.hpp"

//#pragma option -d       // Merge equal strings

instruc_t Instructions[] = {

{ "",                    0                              },              // Unknown Operation
{ "aaa",                 CF_USE1 | CF_CHG1              },              // ASCII Adjust after Addition
{ "aad",                 CF_USE1 | CF_CHG1              },              // ASCII Adjust AX before Division
{ "aam",                 CF_USE1 | CF_CHG1              },              // ASCII Adjust AX after Multiply
{ "aas",                 CF_USE1 | CF_CHG1              },              // ASCII Adjust AL after Subtraction
{ "adc",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Add with Carry
{ "add",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Add
{ "and",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Logical AND
{ "arpl",                CF_CHG1 | CF_USE2              },              // Adjust RPL Field of Selector
{ "bound",               CF_USE1 | CF_USE2              },              // Check Array Index Against Bounds
{ "bsf",                 CF_CHG1 | CF_USE2              },              // Bit Scan Forward
{ "bsr",                 CF_CHG1 | CF_USE2              },              // Bit Scan Reverse
{ "bt",                  CF_USE1 | CF_USE2              },              // Bit Test
{ "btc",                 CF_USE2 | CF_CHG1 | CF_USE1    },              // Bit Test and Complement
{ "btr",                 CF_USE2 | CF_CHG1 | CF_USE1    },              // Bit Test and Reset
{ "bts",                 CF_USE2 | CF_CHG1 | CF_USE1    },              // Bit Test and Set
{ "call",       CF_HLL | CF_CALL | CF_USE1              },              // Call Procedure
{ "call",       CF_HLL | CF_CALL | CF_JUMP | CF_USE1    },              // Indirect Call Far Procedure
{ "call",       CF_HLL | CF_CALL | CF_JUMP | CF_USE1    },              // Indirect Call Near Procedure
{ "cbw",        CF_HLL | CF_USE1 | CF_CHG1              },              // Convert Byte to Word
{ "cwde",       CF_HLL | CF_USE1 | CF_CHG1              },              // Convert Word to Doubleword (use32)
{ "clc",        CF_HLL | 0                              },              // Clear Carry Flag
{ "cld",        CF_HLL | 0                              },              // Clear Direction Flag
{ "cli",        CF_HLL | 0                              },              // Clear Interrupt Flag
{ "clts",                0                              },              // Clear Task-Switched Flag in CR0
{ "cmc",        CF_HLL | 0                              },              // Complement Carry Flag
{ "cmp",        CF_HLL | CF_USE1 | CF_USE2              },              // Compare Two Operands
{ "cmps",                CF_USE1 | CF_USE2 | CF_CHG1 | CF_USE2 },       // Compare String Operands
{ "cwd",        CF_HLL | CF_USE1 | CF_CHG2              },              // Convert Word to Doubleword
{ "cdq",        CF_HLL | CF_USE1 | CF_CHG2              },              // Convert Doubleword to Quadword (use32)
{ "daa",                 CF_USE1 | CF_CHG1              },              // Decimal Adjust AL after Addition
{ "das",                 CF_USE1 | CF_CHG1              },              // Decimal Adjust AL after Subtraction
{ "dec",        CF_HLL | CF_USE1 | CF_CHG1              },              // Decrement by 1
{ "div",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Unsigned Divide
{ "enterw",     CF_HLL | CF_USE1 | CF_USE2              },              // Make Stack Frame for Procedure Parameters
{ "enter",      CF_HLL | CF_USE1 | CF_USE2              },              // Make Stack Frame for Procedure Parameters
{ "enterd",     CF_HLL | CF_USE1 | CF_USE2              },              // Make Stack Frame for Procedure Parameters
{ "hlt",                 0                              },              // Halt
{ "idiv",       CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Signed Divide
{ "imul",       CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Signed Multiply
{ "in",                  CF_USE2 | CF_CHG1              },              // Input from Port
{ "inc",        CF_HLL | CF_USE1 | CF_CHG1              },              // Increment by 1
{ "ins",                 CF_USE2 | CF_CHG2              },              // Input from Port to String
{ "int",                 CF_USE1 | CF_CALL              },              // Call to Interrupt Procedure
{ "into",                CF_CALL                        },              // Call to Interrupt Procedure if Overflow Flag = 1
{ "int",                 CF_USE1                        },              // Trap to Debugger
{ "iretw",               CF_STOP                        },              // Interrupt Return
{ "iret",                CF_STOP                        },              // Interrupt Return
{ "iretd",               CF_STOP                        },              // Interrupt Return (use32)
{ "ja",         CF_HLL | CF_USE1                        },              // Jump if Above (CF=0 & ZF=0)
{ "jae",        CF_HLL | CF_USE1                        },              // Jump if Above or Equal (CF=0)
{ "jb",         CF_HLL | CF_USE1                        },              // Jump if Below (CF=1)
{ "jbe",        CF_HLL | CF_USE1                        },              // Jump if Below or Equal (CF=1 | ZF=1)
{ "jc",         CF_HLL | CF_USE1                        },              // Jump if Carry (CF=1)
{ "jcxz",       CF_HLL | CF_USE1                        },              // Jump if CX is 0
{ "jecxz",      CF_HLL | CF_USE1                        },              // Jump if ECX is 0 (use32)
{ "je",         CF_HLL | CF_USE1                        },              // Jump if Equal (ZF=1)
{ "jg",         CF_HLL | CF_USE1                        },              // Jump if Greater (ZF=0 & SF=OF)
{ "jge",        CF_HLL | CF_USE1                        },              // Jump if Greater or Equal (SF=OF)
{ "jl",         CF_HLL | CF_USE1                        },              // Jump if Less (SF!=OF)
{ "jle",        CF_HLL | CF_USE1                        },              // Jump if Less or Equal (ZF=1 | SF!=OF)
{ "jna",        CF_HLL | CF_USE1                        },              // Jump if Not Above (CF=1 | ZF=1)
{ "jnae",       CF_HLL | CF_USE1                        },              // Jump if Not Above or Equal (CF=1)
{ "jnb",        CF_HLL | CF_USE1                        },              // Jump if Not Below (CF=0)
{ "jnbe",       CF_HLL | CF_USE1                        },              // Jump if Not Below or Equal (CF=0 & ZF=0)
{ "jnc",        CF_HLL | CF_USE1                        },              // Jump if Not Carry (CF=0)
{ "jne",        CF_HLL | CF_USE1                        },              // Jump if Not Equal (ZF=0)
{ "jng",        CF_HLL | CF_USE1                        },              // Jump if Not Greater (ZF=1 | SF!=OF)
{ "jnge",       CF_HLL | CF_USE1                        },              // Jump if Not Greater or Equal (ZF=1)
{ "jnl",        CF_HLL | CF_USE1                        },              // Jump if Not Less (SF=OF)
{ "jnle",       CF_HLL | CF_USE1                        },              // Jump if Not Less or Equal (ZF=0 & SF=OF)
{ "jno",                 CF_USE1                        },              // Jump if Not Overflow (OF=0)
{ "jnp",                 CF_USE1                        },              // Jump if Not Parity (PF=0)
{ "jns",                 CF_USE1                        },              // Jump if Not Sign (SF=0)
{ "jnz",        CF_HLL | CF_USE1                        },              // Jump if Not Zero (ZF=0)
{ "jo",                  CF_USE1                        },              // Jump if Overflow (OF=1)
{ "jp",                  CF_USE1                        },              // Jump if Parity (PF=1)
{ "jpe",                 CF_USE1                        },              // Jump if Parity Even (PF=1)
{ "jpo",                 CF_USE1                        },              // Jump if Parity Odd  (PF=0)
{ "js",                  CF_USE1                        },              // Jump if Sign (SF=1)
{ "jz",         CF_HLL | CF_USE1                        },              // Jump if Zero (ZF=1)
{ "jmp",        CF_HLL | CF_USE1 | CF_STOP              },              // Jump
{ "jmp",        CF_HLL | CF_JUMP | CF_USE1 | CF_STOP    },              // Indirect Far Jump
{ "jmp",        CF_HLL | CF_JUMP | CF_USE1 | CF_STOP    },              // Indirect Near Jump
{ "jmp short",  CF_HLL | CF_STOP | CF_USE1              },              // Jump Short
{ "lahf",                0                              },              // Load Flags into AH Register
{ "lar",                 0                              },              // Load Access Right Byte
{ "lea",        CF_HLL | CF_USE2 | CF_CHG1              },              // Load Effective Address
{ "leavew",     CF_HLL | 0                              },              // High Level Procedure Exit
{ "leave",      CF_HLL | 0                              },              // High Level Procedure Exit
{ "leaved",     CF_HLL | 0                              },              // High Level Procedure Exit
{ "lgdt",                CF_USE1                        },              // Load Global Descriptor Table Register
{ "lidt",                CF_USE1                        },              // Load Interrupt Descriptor Table Register
{ "lgs",        CF_HLL | CF_USE2 | CF_CHG1              },              // Load Full Pointer to GS:xx
{ "lss",                 CF_USE2 | CF_CHG1              },              // Load Full Pointer to SS:xx
{ "lds",        CF_HLL | CF_USE2 | CF_CHG1              },              // Load Full Pointer to DS:xx
{ "les",        CF_HLL | CF_USE2 | CF_CHG1              },              // Load Full Pointer to ES:xx
{ "lfs",        CF_HLL | CF_USE2 | CF_CHG1              },              // Load Full Pointer to FS:xx
{ "lldt",                CF_USE1                        },              // Load Local Descriptor Table Register
{ "lmsw",                CF_USE1                        },              // Load Machine Status Word
{ "",                    0                              },              // Assert LOCK# Signal Prefix
{ "lods",                CF_CHG1 | CF_USE2              },              // Load String Operand
{ "loopw",      CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0
{ "loop",       CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0
{ "loopd",      CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0
{ "loopwe",     CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=1
{ "loope",      CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=1
{ "loopde",     CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=1
{ "loopwne",    CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=0
{ "loopne",     CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=0
{ "loopdne",    CF_HLL | CF_USE1 | CF_CHG2              },              // Loop while CX != 0 and ZF=0
{ "lsl",                 0                              },              // Load Segment Limit
{ "ltr",                 0                              },              // Load Task Register
{ "mov",        CF_HLL | CF_USE2 | CF_CHG1              },              // Move Data
{ "mov",                 CF_USE2 | CF_CHG1              },              // Move to/from Special Registers
{ "movs",                CF_USE1 | CF_USE2 | CF_CHG1    },              // Move Data from String to String
{ "movsx",      CF_HLL | CF_USE2 | CF_CHG1              },              // Move with Sign-Extend
{ "movzx",      CF_HLL | CF_USE2 | CF_CHG1              },              // Move with Zero-Extend
{ "mul",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Unsigned Multiplication of AL or AX
{ "neg",        CF_HLL | CF_USE1 | CF_CHG1              },              // Two's Complement Negation
{ "nop",        CF_HLL | 0                              },              // No Operation
{ "not",        CF_HLL | CF_USE1 | CF_CHG1              },              // One's Complement Negation
{ "or",         CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Logical Inclusive OR
{ "out",                 CF_USE1 | CF_USE2              },              // Output to Port
{ "outs",                CF_USE2 | CF_CHG2              },              // Output String to Port
{ "pop",        CF_HLL | CF_CHG1                        },              // Pop a word from the Stack
{ "popaw",               0                              },              // Pop all General Registers
{ "popa",                0                              },              // Pop all General Registers
{ "popad",               0                              },              // Pop all General Registers (use32)
{ "popfw",               0                              },              // Pop Stack into Flags Register
{ "popf",                0                              },              // Pop Stack into Flags Register
{ "popfd",               0                              },              // Pop Stack into Eflags Register (use32)
{ "push",       CF_HLL | CF_USE1                        },              // Push Operand onto the Stack
{ "pushaw",              0                              },              // Push all General Registers
{ "pusha",               0                              },              // Push all General Registers
{ "pushad",              0                              },              // Push all General Registers (use32)
{ "pushfw",              0                              },              // Push Flags Registeronto the Stack
{ "pushf",               0                              },              // Push Flags Registeronto the Stack
{ "pushfd",              0                              },              // Push Flags Registeronto the Stack (use 32)
{ "rcl",                 CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Rotate Through Carry Left
{ "rcr",                 CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Rotate Through Carry Right
{ "rol",                 CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Rotate Left
{ "ror",                 CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Rotate Right
{ "",                    0                              },              // Repeat String Operation
{ "",                    0                              },              // Repeat String Operation while ZF=1
{ "",                    0                              },              // Repeat String Operation while ZF=0
{ "retn",       CF_HLL | CF_STOP                        },              // Return Near from Procedure
{ "retf",       CF_HLL | CF_STOP                        },              // Return Far from Procedure
{ "sahf",                CF_CHG1                        },              // Store AH into Flags Register
{ "sal",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Shift Arithmetic Left
{ "sar",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Shift Arithmetic Right
{ "shl",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Shift Logical Left
{ "shr",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Shift Logical Right
{ "sbb",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Integer Subtraction with Borrow
{ "scas",                CF_USE1 | CF_USE2 | CF_CHG1    },              // Compare String Data
{ "seta",       CF_HLL | CF_CHG1                        },              // Set Byte if Above (CF=0 & ZF=0)
{ "setae",      CF_HLL | CF_CHG1                        },              // Set Byte if Above or Equal (CF=0)
{ "setb",       CF_HLL | CF_CHG1                        },              // Set Byte if Below (CF=1)
{ "setbe",      CF_HLL | CF_CHG1                        },              // Set Byte if Below or Equal (CF=1 | ZF=1)
{ "setc",       CF_HLL | CF_CHG1                        },              // Set Byte if Carry (CF=1)
{ "sete",       CF_HLL | CF_CHG1                        },              // Set Byte if Equal (ZF=1)
{ "setg",       CF_HLL | CF_CHG1                        },              // Set Byte if Greater (ZF=0 & SF=OF)
{ "setge",      CF_HLL | CF_CHG1                        },              // Set Byte if Greater or Equal (SF=OF)
{ "setl",       CF_HLL | CF_CHG1                        },              // Set Byte if Less (SF!=OF)
{ "setle",      CF_HLL | CF_CHG1                        },              // Set Byte if Less or Equal (ZF=1 | SF!=OF)
{ "setna",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Above (CF=1 | ZF=1)
{ "setnae",     CF_HLL | CF_CHG1                        },              // Set Byte if Not Above or Equal (CF=1)
{ "setnb",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Below (CF=0)
{ "setnbe",     CF_HLL | CF_CHG1                        },              // Set Byte if Not Below or Equal (CF=0 & ZF=0)
{ "setnc",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Carry (CF=0)
{ "setne",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Equal (ZF=0)
{ "setng",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Greater (ZF=1 | SF!=OF)
{ "setnge",     CF_HLL | CF_CHG1                        },              // Set Byte if Not Greater or Equal (ZF=1)
{ "setnl",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Less (SF=OF)
{ "setnle",     CF_HLL | CF_CHG1                        },              // Set Byte if Not Less or Equal (ZF=0 & SF=OF)
{ "setno",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Overflow (OF=0)
{ "setnp",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Parity (PF=0)
{ "setns",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Sign (SF=0)
{ "setnz",      CF_HLL | CF_CHG1                        },              // Set Byte if Not Zero (ZF=0)
{ "seto",       CF_HLL | CF_CHG1                        },              // Set Byte if Overflow (OF=1)
{ "setp",       CF_HLL | CF_CHG1                        },              // Set Byte if Parity (PF=1)
{ "setpe",      CF_HLL | CF_CHG1                        },              // Set Byte if Parity Even (PF=1)
{ "setpo",      CF_HLL | CF_CHG1                        },              // Set Byte if Parity Odd  (PF=0)
{ "sets",       CF_HLL | CF_CHG1                        },              // Set Byte if Sign (SF=1)
{ "setz",       CF_HLL | CF_CHG1                        },              // Set Byte if Zero (ZF=1)
{ "sgdt",                CF_CHG1                        },              // Store Global Descriptor Table Register
{ "sidt",                CF_CHG1                        },              // Store Interrupt Descriptor Table Register
{ "shld",       CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Double Precision Shift Left
{ "shrd",       CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_SHFT },       // Double Precision Shift Right
{ "sldt",                CF_CHG1                        },              // Store Local Descriptor Table Register
{ "smsw",                CF_CHG1                        },              // Store Machine Status Word
{ "stc",        CF_HLL | 0                              },              // Set Carry Flag
{ "std",        CF_HLL | 0                              },              // Set Direction Flag
{ "sti",        CF_HLL | 0                              },              // Set Interrupt Flag
{ "stos",                CF_USE1 | CF_USE2 | CF_CHG1    },              // Store String Data
{ "str",                 CF_CHG1                        },              // Store Task Register
{ "sub",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Integer Subtraction
{ "test",       CF_HLL | CF_USE1 | CF_USE2              },              // Logical Compare
{ "verr",                CF_USE1                        },              // Verify a Segment for Reading
{ "verw",                CF_USE1                        },              // Verify a Segment for Writing
{ "wait",       CF_HLL | 0                              },              // Wait until BUSY# Pin is Inactive (HIGH)
{ "xchg",       CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1 | CF_CHG2 },       // Exchange Register/Memory with Register
{ "xlat",                CF_CHG1 | CF_USE1 | CF_USE2    },              // Table Lookup Translation
{ "xor",        CF_HLL | CF_USE1 | CF_USE2 | CF_CHG1    },              // Logical Exclusive OR


//
//      486 instructions
//

{ "cmpxchg",    CF_USE1|CF_USE2|CF_CHG1         },         // Compare and Exchange
{ "bswap",      CF_CHG1                         },         // Swap bits in EAX
{ "xadd",       CF_USE1 | CF_USE2 | CF_CHG1 | CF_CHG2 },   // t<-dest; dest<-src+dest; src<-t
{ "invd",       0                               },         // Invalidate Data Cache
{ "wbinvd",     0                               },         // Invalidate Data Cache (write changes)
{ "invlpg",     CF_USE1                         },         // Invalidate TLB entry

//
//      Pentium instructions
//

{ "rdmsr",      0                               },         // Read Machine Status Register
{ "wrmsr",      0                               },         // Write Machine Status Register
{ "cpuid",      0                               },         // Get CPU ID
{ "cmpxchg8b",  CF_CHG1                         },         // Compare and Exchange Eight Bytes
{ "rdtsc",      0                               },         // Read Time Stamp Counter
{ "rsm",        0                               },         // Resume from System Management Mode

//
//      Pentium Pro instructions
//

{ "cmova",      CF_CHG1 | CF_USE2               },         // Move if Above (CF=0 & ZF=0)
{ "cmovb",      CF_CHG1 | CF_USE2               },         // Move if Below (CF=1)
{ "cmovbe",     CF_CHG1 | CF_USE2               },         // Move if Below or Equal (CF=1 | ZF=1)
{ "cmovg",      CF_CHG1 | CF_USE2               },         // Move if Greater (ZF=0 & SF=OF)
{ "cmovge",     CF_CHG1 | CF_USE2               },         // Move if Greater or Equal (SF=OF)
{ "cmovl",      CF_CHG1 | CF_USE2               },         // Move if Less (SF!=OF)
{ "cmovle",     CF_CHG1 | CF_USE2               },         // Move if Less or Equal (ZF=1 | SF!=OF)
{ "cmovnb",     CF_CHG1 | CF_USE2               },         // Move if Not Below (CF=0)
{ "cmovno",     CF_CHG1 | CF_USE2               },         // Move if Not Overflow (OF=0)
{ "cmovnp",     CF_CHG1 | CF_USE2               },         // Move if Not Parity (PF=0)
{ "cmovns",     CF_CHG1 | CF_USE2               },         // Move if Not Sign (SF=0)
{ "cmovnz",     CF_CHG1 | CF_USE2               },         // Move if Not Zero (ZF=0)
{ "cmovo",      CF_CHG1 | CF_USE2               },         // Move if Overflow (OF=1)
{ "cmovp",      CF_CHG1 | CF_USE2               },         // Move if Parity (PF=1)
{ "cmovs",      CF_CHG1 | CF_USE2               },         // Move if Sign (SF=1)
{ "cmovz",      CF_CHG1 | CF_USE2               },         // Move if Zero (ZF=1)
{ "fcmovb",     CF_CHG1 | CF_USE2               },         // Floating Move if Below
{ "fcmove",     CF_CHG1 | CF_USE2               },         // Floating Move if Equal
{ "fcmovbe",    CF_CHG1 | CF_USE2               },         // Floating Move if Below or Equal
{ "fcmovu",     CF_CHG1 | CF_USE2               },         // Floating Move if Unordered
{ "fcmovnb",    CF_CHG1 | CF_USE2               },         // Floating Move if Not Below
{ "fcmovne",    CF_CHG1 | CF_USE2               },         // Floating Move if Not Equal
{ "fcmovnbe",   CF_CHG1 | CF_USE2               },         // Floating Move if Not Below or Equal
{ "fcmovnu",    CF_CHG1 | CF_USE2               },         // Floating Move if Not Unordered
{ "fcomi",      CF_CHG1 | CF_USE2               },         // FP Compare, result in EFLAGS
{ "fucomi",     CF_CHG1 | CF_USE2               },         // FP Unordered Compare, result in EFLAGS
{ "fcomip",     CF_CHG1 | CF_USE2               },         // FP Compare, result in EFLAGS, pop stack
{ "fucomip",    CF_CHG1 | CF_USE2               },         // FP Unordered Compare, result in EFLAGS, pop stack
{ "rdpmc",      0                               },         // Read Performance Monitor Counter

//
//      FPP instructuions
//

{ "fld",        CF_USE2                         },         // Load Real
{ "fst",        CF_CHG2                         },         // Store Real
{ "fstp",       CF_CHG2                         },         // Store Real and Pop
{ "fxch",       0                               },         // Exchange Registers
{ "fild",       CF_USE2                         },         // Load Integer
{ "fist",       CF_CHG2                         },         // Store Integer
{ "fistp",      CF_CHG2                         },         // Store Integer and Pop
{ "fbld",       CF_USE2                         },         // Load BCD
{ "fbstp",      CF_CHG2                         },         // Store BCD and Pop
{ "fadd",       CF_USE2                         },         // Add Real
{ "faddp",      CF_USE2                         },         // Add Real and Pop
{ "fiadd",      CF_USE2                         },         // Add Integer
{ "fsub",       CF_USE2                         },         // Subtract Real
{ "fsubp",      CF_USE2                         },         // Subtract Real and Pop
{ "fisub",      CF_USE2                         },         // Subtract Integer
{ "fsubr",      CF_USE2                         },         // Subtract Real Reversed
{ "fsubrp",     CF_USE2                         },         // Subtract Real Reversed and Pop
{ "fisubr",     CF_USE2                         },         // Subtract Integer Reversed
{ "fmul",       CF_USE2                         },         // Multiply Real
{ "fmulp",      CF_USE2                         },         // Multiply Real and Pop
{ "fimul",      CF_USE2                         },         // Multiply Integer
{ "fdiv",       CF_USE2                         },         // Divide Real
{ "fdivp",      CF_USE2                         },         // Divide Real and Pop
{ "fidiv",      CF_USE2                         },         // Divide Integer
{ "fdivr",      CF_USE2                         },         // Divide Real Reversed
{ "fdivrp",     CF_USE2                         },         // Divide Real Reversed and Pop
{ "fidivr",     CF_USE2                         },         // Divide Integer Reversed
{ "fsqrt",      CF_USE1                         },         // Square Root
{ "fscale",     CF_USE1                         },         // Scale:  st(0) <- st(0) * 2^st(1)
{ "fprem",      CF_USE1                         },         // Partial Remainder
{ "frndint",    CF_USE1                         },         // Round to Integer
{ "fxtract",    CF_USE1                         },         // Extract exponent and significand
{ "fabs",       CF_USE1                         },         // Absolute value
{ "fchs",       CF_USE1                         },         // Change Sign
{ "fcom",       CF_USE2                         },         // Compare Real
{ "fcomp",      CF_USE2                         },         // Compare Real and Pop
{ "fcompp",     CF_USE1                         },         // Compare Real and Pop Twice
{ "ficom",      CF_USE2                         },         // Compare Integer
{ "ficomp",     CF_USE2                         },         // Compare Integer and Pop
{ "ftst",       CF_USE1                         },         // Test
{ "fxam",       CF_USE1                         },         // Examine
{ "fptan",      CF_USE1                         },         // Partial tangent
{ "fpatan",     CF_USE1                         },         // Partial arctangent
{ "f2xm1",      CF_USE1                         },         // 2^x - 1
{ "fyl2x",      0                               },         // Y * lg2(X)
{ "fyl2xp1",    0                               },         // Y * lg2(X+1)
{ "fldz",       0                               },         // Load +0.0
{ "fld1",       0                               },         // Load +1.0
{ "fldpi",      0                               },         // Load PI=3.14...
{ "fldl2t",     0                               },         // Load lg2(10)
{ "fldl2e",     0                               },         // Load lg2(e)
{ "fldlg2",     0                               },         // Load lg10(2)
{ "fldln2",     0                               },         // Load ln(2)
{ "finit",      0                               },         // Initialize Processor
{ "fninit",     0                               },         // Initialize Processor (no wait)
{ "fsetpm",     0                               },         // Set Protected Mode
{ "fldcw",      CF_USE2                         },         // Load Control Word
{ "fstcw",      CF_CHG2                         },         // Store Control Word
{ "fnstcw",     CF_CHG2                         },         // Store Control Word (no wait)
{ "fstsw",      CF_CHG2                         },         // Store Status Word
{ "fnstsw",     CF_CHG2                         },         // Store Status Word (no wait)
{ "fclex",      0                               },         // Clear Exceptions
{ "fnclex",     0                               },         // Clear Exceptions (no wait)
{ "fstenv",     CF_CHG2                         },         // Store Environment
{ "fnstenv",    CF_CHG2                         },         // Store Environment (no wait)
{ "fldenv",     CF_USE2                         },         // Load Environment
{ "fsave",      CF_CHG2                         },         // Save State
{ "fnsave",     CF_CHG2                         },         // Save State (no wait)
{ "frstor",     CF_USE2                         },         // Restore State
{ "fincstp",    0                               },         // Increment Stack Pointer
{ "fdecstp",    0                               },         // Decrement Stack Pointer
{ "ffree",      0                               },         // Free Register
{ "fnop",       0                               },         // No Operation
{ "feni",       0                               },         // (8087 only)
{ "fneni",      0                               },         // (no wait) (8087 only)
{ "fdisi",      0                               },         // (8087 only)
{ "fndisi",     0                               },         // (no wait) (8087 only)

//
//      80387 instructions
//

{ "fprem1",     0                               },         // Partial Remainder ( < half )
{ "fsincos",    0                               },         // t<-cos(st); st<-sin(st); push t
{ "fsin",       0                               },         // Sine
{ "fcos",       0                               },         // Cosine
{ "fucom",      CF_USE2                         },         // Compare Unordered Real
{ "fucomp",     CF_USE2                         },         // Compare Unordered Real and Pop
{ "fucompp",    CF_USE1                         },         // Compare Unordered Real and Pop Twice

//
//      Instructions added 28.02.96
//

{ "setalc",     0                               },         // Set AL to Carry Flag
{ "svdc",       CF_CHG1|CF_USE2                 },         // Save Register and Descriptor
{ "rsdc",       CF_USE1|CF_CHG2                 },         // Restore Register and Descriptor
{ "svldt",      CF_CHG1                         },         // Save LDTR and Descriptor
{ "rsldt",      CF_USE1                         },         // Restore LDTR and Descriptor
{ "svts",       CF_CHG1                         },         // Save TR and Descriptor
{ "rsts",       CF_USE1                         },         // Restore TR and Descriptor
{ "icebp",      0                               },         // ICE Break Point
{ "loadall",    0                               },         // Load the entire CPU state from ES:EDI

//
//      MMX instructions
//

{ "emms",       0                               },         // Empty MMX state
{ "movd",       CF_CHG1|CF_USE2                 },         // Move 32 bits
{ "movq",       CF_CHG1|CF_USE2                 },         // Move 64 bits
{ "packsswb",   CF_CHG1|CF_USE2                 },         // Pack with Signed Saturation (Word->Byte)
{ "packssdw",   CF_CHG1|CF_USE2                 },         // Pack with Signed Saturation (Dword->Word)
{ "packuswb",   CF_CHG1|CF_USE2                 },         // Pack with Unsigned Saturation (Word->Byte)
{ "paddb",      CF_CHG1|CF_USE2                 },         // Packed Add Byte
{ "paddw",      CF_CHG1|CF_USE2                 },         // Packed Add Word
{ "paddd",      CF_CHG1|CF_USE2                 },         // Packed Add Dword
{ "paddsb",     CF_CHG1|CF_USE2                 },         // Packed Add with Saturation (Byte)
{ "paddsw",     CF_CHG1|CF_USE2                 },         // Packed Add with Saturation (Word)
{ "paddusb",    CF_CHG1|CF_USE2                 },         // Packed Add Unsigned with Saturation (Byte)
{ "paddusw",    CF_CHG1|CF_USE2                 },         // Packed Add Unsigned with Saturation (Word)
{ "pand",       CF_CHG1|CF_USE2                 },         // Bitwise Logical And
{ "pandn",      CF_CHG1|CF_USE2                 },         // Bitwise Logical And Not
{ "pcmpeqb",    CF_USE1|CF_USE2                 },         // Packed Compare for Equal (Byte)
{ "pcmpeqw",    CF_USE1|CF_USE2                 },         // Packed Compare for Equal (Word)
{ "pcmpeqd",    CF_USE1|CF_USE2                 },         // Packed Compare for Equal (Dword)
{ "pcmpgtb",    CF_USE1|CF_USE2                 },         // Packed Compare for Greater Than (Byte)
{ "pcmpgtw",    CF_USE1|CF_USE2                 },         // Packed Compare for Greater Than (Word)
{ "pcmpgtd",    CF_USE1|CF_USE2                 },         // Packed Compare for Greater Than (Dword)
{ "pmaddwd",    CF_CHG1|CF_USE2                 },         // Packed Multiply and Add
{ "pmulhw",     CF_CHG1|CF_USE2                 },         // Packed Multiply High
{ "pmullw",     CF_CHG1|CF_USE2                 },         // Packed Multiply Low
{ "por",        CF_CHG1|CF_USE2                 },         // Bitwise Logical Or
{ "psllw",      CF_CHG1|CF_USE2                 },         // Packed Shift Left Logical (Word)
{ "pslld",      CF_CHG1|CF_USE2                 },         // Packed Shift Left Logical (Dword)
{ "psllq",      CF_CHG1|CF_USE2                 },         // Packed Shift Left Logical (Qword)
{ "psraw",      CF_CHG1|CF_USE2                 },         // Packed Shift Right Arithmetic (Word)
{ "psrad",      CF_CHG1|CF_USE2                 },         // Packed Shift Right Arithmetic (Dword)
{ "psrlw",      CF_CHG1|CF_USE2                 },         // Packed Shift Right Logical (Word)
{ "psrld",      CF_CHG1|CF_USE2                 },         // Packed Shift Right Logical (Dword)
{ "psrlq",      CF_CHG1|CF_USE2                 },         // Packed Shift Right Logical (Qword)
{ "psubb",      CF_CHG1|CF_USE2                 },         // Packed Subtract Byte
{ "psubw",      CF_CHG1|CF_USE2                 },         // Packed Subtract Word
{ "psubd",      CF_CHG1|CF_USE2                 },         // Packed Subtract Dword
{ "psubsb",     CF_CHG1|CF_USE2                 },         // Packed Subtract with Saturation (Byte)
{ "psubsw",     CF_CHG1|CF_USE2                 },         // Packed Subtract with Saturation (Word)
{ "psubusb",    CF_CHG1|CF_USE2                 },         // Packed Subtract Unsigned with Saturation (Byte)
{ "psubusw",    CF_CHG1|CF_USE2                 },         // Packed Subtract Unsigned with Saturation (Word)
{ "punpckhbw",  CF_CHG1|CF_USE2                 },         // Unpack High Packed Data (Byte->Word)
{ "punpckhwd",  CF_CHG1|CF_USE2                 },         // Unpack High Packed Data (Word->Dword)
{ "punpckhdq",  CF_CHG1|CF_USE2                 },         // Unpack High Packed Data (Dword->Qword)
{ "punpcklbw",  CF_CHG1|CF_USE2                 },         // Unpack Low Packed Data (Byte->Word)
{ "punpcklwd",  CF_CHG1|CF_USE2                 },         // Unpack Low Packed Data (Word->Dword)
{ "punpckldq",  CF_CHG1|CF_USE2                 },         // Unpack Low Packed Data (Dword->Qword)
{ "pxor",       CF_CHG1|CF_USE2                 },         // Bitwise Logical Exclusive Or

//
//      Undocumented Deschutes processor instructions
//

{ "fxsave",     CF_CHG1                         },         // Fast Save FP State
{ "fxrstor",    CF_USE1                         },         // Fast Restore FP State

//      Pentium II instructions

{ "sysenter",   0                               },         // Fast Transition to System Call Entry Point
{ "sysexit",    0                               },         // Fast Transition from System Call Entry Point

//      3DNow! instructions

{ "pavgusb",    CF_CHG1|CF_USE2                 },         // Packed 8-bit Unsigned Integer Averaging
{ "pfadd",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Addition
{ "pfsub",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Subtraction
{ "pfsubr",     CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reverse Subtraction
{ "pfacc",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Accumulate
{ "pfcmpge",    CF_USE1|CF_USE2                 },         // Packed Floating-Point Comparison, Greater or Equal
{ "pfcmpgt",    CF_USE1|CF_USE2                 },         // Packed Floating-Point Comparison, Greater
{ "pfcmpeq",    CF_USE1|CF_USE2                 },         // Packed Floating-Point Comparison, Equal
{ "pfmin",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Minimum
{ "pfmax",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Maximum
{ "pi2fd",      CF_CHG1|CF_USE2                 },         // Packed 32-bit Integer to Floating-Point
{ "pf2id",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point to 32-bit Integer
{ "pfrcp",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reciprocal Approximation
{ "pfrsqrt",    CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reciprocal Square Root Approximation
{ "pfmul",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point Multiplication
{ "pfrcpit1",   CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reciprocal First Iteration Step
{ "pfrsqit1",   CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reciprocal Square Root First Iteration Step
{ "pfrcpit2",   CF_CHG1|CF_USE2                 },         // Packed Floating-Point Reciprocal Second Iteration Step
{ "pmulhrw",    CF_CHG1|CF_USE2                 },         // Packed Floating-Point 16-bit Integer Multiply with rounding
{ "femms",      0                               },         // Faster entry/exit of the MMX or floating-point state
{ "prefetch",   CF_USE1                         },         // Prefetch processor cache line into L1 data cache
{ "prefetchw",  CF_CHG1                         },         // Prefetch processor cache line into L1 data cache (mark as modified)

//      Pentium III instructions

{ "addps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Add
{ "addss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Add
{ "andnps",     CF_CHG1|CF_USE2                 },         // Bitwise Logical And Not for Single-FP
{ "andps",      CF_CHG1|CF_USE2                 },         // Bitwise Logical And for Single-FP
{ "cmpps",      CF_USE1|CF_USE2|CF_USE3         },         // Packed Single-FP Compare
{ "cmpss",      CF_USE1|CF_USE2|CF_USE3         },         // Scalar Single-FP Compare
{ "comiss",     CF_USE1|CF_USE2                 },         // Scalar Ordered Single-FP Compare and Set EFLAGS
{ "cvtpi2ps",   CF_CHG1|CF_USE2                 },         // Packed signed INT32 to Packed Single-FP conversion
{ "cvtps2pi",   CF_CHG1|CF_USE2                 },         // Packed Single-FP to Packed INT32 conversion
{ "cvtsi2ss",   CF_CHG1|CF_USE2                 },         // Scalar signed INT32 to Single-FP conversion
{ "cvtss2si",   CF_CHG1|CF_USE2                 },         // Scalar Single-FP to signed INT32 conversion
{ "cvttps2pi",  CF_CHG1|CF_USE2                 },         // Packed Single-FP to Packed INT32 conversion (truncate)
{ "cvttss2si",  CF_CHG1|CF_USE2                 },         // Scalar Single-FP to signed INT32 conversion (truncate)
{ "divps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Divide
{ "divss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Divide
// fxrestor
// fxsave
{ "ldmxcsr",    CF_USE1                         },         // Load Streaming SIMD Extensions Technology Control/Status Register
{ "maxps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Maximum
{ "maxss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Maximum
{ "minps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Minimum
{ "minss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Minimum
{ "movaps",     CF_CHG1|CF_USE2                 },         // Move Aligned Four Packed Single-FP
{ "movhlps",    CF_CHG1|CF_USE2                 },         // Move High to Low Packed Single-FP
{ "movhps",     CF_CHG1|CF_USE2                 },         // Move High Packed Single-FP
{ "movlhps",    CF_CHG1|CF_USE2                 },         // Move Low to High Packed Single-FP
{ "movlps",     CF_CHG1|CF_USE2                 },         // Move Low Packed Single-FP
{ "movmskps",   CF_CHG1|CF_USE2                 },         // Move Mask to Register
{ "movss",      CF_CHG1|CF_USE2                 },         // Move Scalar Single-FP
{ "movups",     CF_CHG1|CF_USE2                 },         // Move Unaligned Four Packed Single-FP
{ "mulps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Multiply
{ "mulss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Multiply
{ "orps",       CF_CHG1|CF_USE2                 },         // Bitwise Logical OR for Single-FP Data
{ "rcpps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Reciprocal
{ "rcpss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Reciprocal
{ "rsqrtps",    CF_CHG1|CF_USE2                 },         // Packed Single-FP Square Root Reciprocal
{ "rsqrtss",    CF_CHG1|CF_USE2                 },         // Scalar Single-FP Square Root Reciprocal
{ "shufps",     CF_CHG1|CF_USE2|CF_USE3         },         // Shuffle Single-FP
{ "sqrtps",     CF_CHG1|CF_USE2                 },         // Packed Single-FP Square Root
{ "sqrtss",     CF_CHG1|CF_USE2                 },         // Scalar Single-FP Square Root
{ "stmxcsr",    CF_CHG1                         },         // Store Streaming SIMD Extensions Technology Control/Status Register
{ "subps",      CF_CHG1|CF_USE2                 },         // Packed Single-FP Subtract
{ "subss",      CF_CHG1|CF_USE2                 },         // Scalar Single-FP Subtract
{ "ucomiss",    CF_USE1|CF_USE2                 },         // Scalar Unordered Single-FP Compare and Set EFLAGS
{ "unpckhps",   CF_CHG1|CF_USE2                 },         // Unpack High Packed Single-FP Data
{ "unpcklps",   CF_CHG1|CF_USE2                 },         // Unpack Low Packed Single-FP Data
{ "xorps",      CF_CHG1|CF_USE2                 },         // Bitwise Logical XOR for Single-FP Data
{ "pavgb",      CF_CHG1|CF_USE2                 },         // Packed Average (Byte)
{ "pavgw",      CF_CHG1|CF_USE2                 },         // Packed Average (Word)
{ "pextrw",     CF_CHG1|CF_USE2|CF_USE3         },         // Extract Word
{ "pinsrw",     CF_CHG1|CF_USE2|CF_USE3         },         // Insert Word
{ "pmaxsw",     CF_CHG1|CF_USE2                 },         // Packed Signed Integer Word Maximum
{ "pmaxub",     CF_CHG1|CF_USE2                 },         // Packed Unsigned Integer Byte Maximum
{ "pminsw",     CF_CHG1|CF_USE2                 },         // Packed Signed Integer Word Minimum
{ "pminub",     CF_CHG1|CF_USE2                 },         // Packed Unsigned Integer Byte Minimum
{ "pmovmskb",   CF_CHG1|CF_USE2                 },         // Move Byte Mask to Integer
{ "pmulhuw",    CF_CHG1|CF_USE2                 },         // Packed Multiply High Unsigned
{ "psadbw",     CF_CHG1|CF_USE2                 },         // Packed Sum of Absolute Differences
{ "pshufw",     CF_CHG1|CF_USE2|CF_USE3         },         // Packed Shuffle Word
{ "maskmovq",   CF_CHG1|CF_USE2                 },         // Byte Mask write
{ "movntps",    CF_CHG1|CF_USE2                 },         // Move Aligned Four Packed Single-FP Non Temporal
{ "movntq",     CF_CHG1|CF_USE2                 },         // Move 64 Bits Non Temporal
{ "prefetcht0", CF_USE1                         },         // Prefetch to all cache levels
{ "prefetcht1", CF_USE1                         },         // Prefetch to all cache levels
{ "prefetcht2", CF_USE1                         },         // Prefetch to L2 cache
{ "prefetchnta",CF_USE1                         },         // Prefetch to L1 cache
{ "sfence",     0                               },         // Store Fence

// Pentium III Pseudo instructions

{ "cmpeqps",    CF_USE1|CF_USE2                 },         // Packed Single-FP Compare EQ
{ "cmpltps",    CF_USE1|CF_USE2                 },         // Packed Single-FP Compare LT
{ "cmpleps",    CF_USE1|CF_USE2                 },         // Packed Single-FP Compare LE
{ "cmpunordps", CF_USE1|CF_USE2                 },         // Packed Single-FP Compare UNORD
{ "cmpneqps",   CF_USE1|CF_USE2                 },         // Packed Single-FP Compare NOT EQ
{ "cmpnltps",   CF_USE1|CF_USE2                 },         // Packed Single-FP Compare NOT LT
{ "cmpnleps",   CF_USE1|CF_USE2                 },         // Packed Single-FP Compare NOT LE
{ "cmpordps",   CF_USE1|CF_USE2                 },         // Packed Single-FP Compare ORDERED
{ "cmpeqss",    CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare EQ
{ "cmpltss",    CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare LT
{ "cmpless",    CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare LE
{ "cmpunordss", CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare UNORD
{ "cmpneqss",   CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare NOT EQ
{ "cmpnltss",   CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare NOT LT
{ "cmpnless",   CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare NOT LE
{ "cmpordss",   CF_USE1|CF_USE2                 },         // Scalar Single-FP Compare ORDERED

// AMD K7 instructions

{ "pf2iw",      CF_CHG1|CF_USE2                 },         // Packed Floating-Point to Integer with Sign Extend
{ "pfnacc",     CF_CHG1|CF_USE2                 },         // Packed Floating-Point Negative Accumulate
{ "pfpnacc",    CF_CHG1|CF_USE2                 },         // Packed Floating-Point Mixed Positive-Negative Accumulate
{ "pi2fw",      CF_CHG1|CF_USE2                 },         // Packed 16-bit Integer to Floating-Point
{ "pswapd",     CF_CHG1|CF_USE2                 },         // Packed Swap Double Word

// Undocumented FP instructions (thanks to norbert.juffa@adm.com)

{ "fstp1",      CF_USE1|CF_USE2                 },         // Alias of Store Real and Pop
{ "fcom2",      CF_USE1|CF_USE2                 },         // Alias of Compare Real
{ "fcomp3",     CF_USE1|CF_USE2                 },         // Alias of Compare Real and Pop
{ "fxch4",      CF_USE1|CF_USE2                 },         // Alias of Exchange Registers
{ "fcomp5",     CF_USE1|CF_USE2                 },         // Alias of Compare Real and Pop
{ "ffreep",     CF_USE1|CF_USE2                 },         // Free Register and Pop
{ "fxch7",      CF_USE1|CF_USE2                 },         // Alias of Exchange Registers
{ "fstp8",      CF_USE1|CF_USE2                 },         // Alias of Store Real and Pop
{ "fstp9",      CF_USE1|CF_USE2                 },         // Alias of Store Real and Pop


// Pentium 4 instructions

{ "addpd",      CF_CHG1|CF_USE2                 },         // Add Packed Double-Precision Floating-Point Values
{ "addsd",      CF_CHG1|CF_USE2                 },         // Add Scalar Double-Precision Floating-Point Values
{ "andnpd",     CF_CHG1|CF_USE2                 },         // Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values
{ "andpd",      CF_CHG1|CF_USE2                 },         // Bitwise Logical AND of Packed Double-Precision Floating-Point Values
{ "clflush",    CF_USE1                         },         // Flush Cache Line
{ "cmppd",      CF_CHG1|CF_USE2|CF_USE3         },         // Compare Packed Double-Precision Floating-Point Values
{ "cmpsd",      CF_CHG1|CF_USE2|CF_USE3         },         // Compare Scalar Double-Precision Floating-Point Values
{ "comisd",     CF_CHG1|CF_USE2                 },         // Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS
{ "cvtdq2pd",   CF_CHG1|CF_USE2                 },         // Convert Packed Doubleword Integers to Packed Single-Precision Floating-Point Values
{ "cvtdq2ps",   CF_CHG1|CF_USE2                 },         // Convert Packed Doubleword Integers to Packed Double-Precision Floating-Point Values
{ "cvtpd2dq",   CF_CHG1|CF_USE2                 },         // Convert Packed Double-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvtpd2pi",   CF_CHG1|CF_USE2                 },         // Convert Packed Double-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvtpd2ps",   CF_CHG1|CF_USE2                 },         // Convert Packed Double-Precision Floating-Point Values to Packed Single-Precision Floating-Point Values
{ "cvtpi2pd",   CF_CHG1|CF_USE2                 },         // Convert Packed Doubleword Integers to Packed Double-Precision Floating-Point Values
{ "cvtps2dq",   CF_CHG1|CF_USE2                 },         // Convert Packed Single-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvtps2pd",   CF_CHG1|CF_USE2                 },         // Convert Packed Single-Precision Floating-Point Values to Packed Double-Precision Floating-Point Values
{ "cvtsd2si",   CF_CHG1|CF_USE2                 },         // Convert Scalar Double-Precision Floating-Point Value to Doubleword Integer
{ "cvtsd2ss",   CF_CHG1|CF_USE2                 },         // Convert Scalar Double-Precision Floating-Point Value to Scalar Single-Precision Floating-Point Value
{ "cvtsi2sd",   CF_CHG1|CF_USE2                 },         // Convert Doubleword Integer to Scalar Double-Precision Floating-Point Value
{ "cvtss2sd",   CF_CHG1|CF_USE2                 },         // Covert Scalar Single-Precision Floating-Point Value to Scalar Double-Precision Floating-Point Value
{ "cvttpd2dq",  CF_CHG1|CF_USE2                 },         // Convert With Truncation Packed Double-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvttpd2pi",  CF_CHG1|CF_USE2                 },         // Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvttps2dq",  CF_CHG1|CF_USE2                 },         // Convert With Truncation Packed Single-Precision Floating-Point Values to Packed Doubleword Integers
{ "cvttsd2si",  CF_CHG1|CF_USE2                 },         // Convert with Truncation Scalar Double-Precision Floating-Point Value to Doubleword Integer
{ "divpd",      CF_CHG1|CF_USE2                 },         // Divide Packed Double-Precision Floating-Point Values
{ "divsd",      CF_CHG1|CF_USE2                 },         // Divide Scalar Double-Precision Floating-Point Values
{ "lfence",     0                               },         // Load Fence
{ "maskmovdqu", CF_CHG1|CF_USE2                 },         // Store Selected Bytes of Double Quadword
{ "maxpd",      CF_CHG1|CF_USE2                 },         // Return Maximum Packed Double-Precision Floating-Point Values
{ "maxsd",      CF_CHG1|CF_USE2                 },         // Return Maximum Scalar Double-Precision Floating-Point Value
{ "mfence",     0                               },         // Memory Fence
{ "minpd",      CF_CHG1|CF_USE2                 },         // Return Minimum Packed Double-Precision Floating-Point Values
{ "minsd",      CF_CHG1|CF_USE2                 },         // Return Minimum Scalar Double-Precision Floating-Point Value
{ "movapd",     CF_CHG1|CF_USE2                 },         // Move Aligned Packed Double-Precision Floating-Point Values
{ "movdq2q",    CF_CHG1|CF_USE2                 },         // Move Quadword from XMM to MMX Register
{ "movdqa",     CF_CHG1|CF_USE2                 },         // Move Aligned Double Quadword
{ "movdqu",     CF_CHG1|CF_USE2                 },         // Move Unaligned Double Quadword
{ "movhpd",     CF_CHG1|CF_USE2                 },         // Move High Packed Double-Precision Floating-Point Values
{ "movlpd",     CF_CHG1|CF_USE2                 },         // Move Low Packed Double-Precision Floating-Point Values
{ "movmskpd",   CF_CHG1|CF_USE2                 },         // Extract Packed Double-Precision Floating-Point Sign Mask
{ "movntdq",    CF_CHG1|CF_USE2                 },         // Store Double Quadword Using Non-Temporal Hint
{ "movnti",     CF_CHG1|CF_USE2                 },         // Store Doubleword Using Non-Temporal Hint
{ "movntpd",    CF_CHG1|CF_USE2                 },         // Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint
{ "movq2dq",    CF_CHG1|CF_USE2                 },         // Move Quadword from MMX to XMM Register
{ "movsd",      CF_CHG1|CF_USE2                 },         // Move Scalar Double-Precision Floating-Point Values
{ "movupd",     CF_CHG1|CF_USE2                 },         // Move Unaligned Packed Double-Precision Floating-Point Values
{ "mulpd",      CF_CHG1|CF_USE2                 },         // Multiply Packed Double-Precision Floating-Point Values
{ "mulsd",      CF_CHG1|CF_USE2                 },         // Multiply Scalar Double-Precision Floating-Point Values
{ "orpd",       CF_CHG1|CF_USE2                 },         // Bitwise Logical OR of Double-Precision Floating-Point Values
{ "paddq",      CF_CHG1|CF_USE2                 },         // Add Packed Quadword Integers
{ "pause",      0                               },         // Spin Loop Hint
{ "pmuludq",    CF_CHG1|CF_USE2                 },         // Multiply Packed Unsigned Doubleword Integers
{ "pshufd",     CF_CHG1|CF_USE2                 },         // Shuffle Packed Doublewords
{ "pshufhw",    CF_CHG1|CF_USE2                 },         // Shuffle Packed High Words
{ "pshuflw",    CF_CHG1|CF_USE2                 },         // Shuffle Packed Low Words
{ "pslldq",     CF_CHG1|CF_USE2                 },         // Shift Double Quadword Left Logical
{ "psrldq",     CF_CHG1|CF_USE2                 },         // Shift Double Quadword Right Logical
{ "psubq",      CF_CHG1|CF_USE2                 },         // Subtract Packed Quadword Integers
{ "punpckhqdq", CF_CHG1|CF_USE2                 },         // Unpack High Data
{ "punpcklqdq", CF_CHG1|CF_USE2                 },         // Unpack Low Data
{ "shufpd",     CF_CHG1|CF_USE2                 },         // Shuffle Packed Double-Precision Floating-Point Values
{ "sqrtpd",     CF_CHG1|CF_USE2                 },         // Compute Square Roots of Packed Double-Precision Floating-Point Values
{ "sqrtsd",     CF_CHG1|CF_USE2                 },         // Compute Square Rootof Scalar Double-Precision Floating-Point Value
{ "subpd",      CF_CHG1|CF_USE2                 },         // Subtract Packed Double-Precision Floating-Point Values
{ "subsd",      CF_CHG1|CF_USE2                 },         // Subtract Scalar Double-Precision Floating-Point Values
{ "ucomisd",    CF_CHG1|CF_USE2                 },         // Unordered Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS
{ "unpckhpd",   CF_CHG1|CF_USE2                 },         // Unpack and Interleave High Packed Double-Precision Floating-Point Values
{ "unpcklpd",   CF_CHG1|CF_USE2                 },         // Unpack and Interleave Low Packed Double-Precision Floating-Point Values
{ "xorpd",      CF_CHG1|CF_USE2                 },         // Bitwise Logical OR of Double-Precision Floating-Point Values

{ "syscall",    0                               },         // Low latency system call
{ "sysret",     0                               },         // Return from system call
  };

#ifdef __BORLANDC__
#if sizeof(Instructions)/sizeof(Instructions[0]) != NN_last
#error          No match:  sizeof(InstrNames) !!!
#endif
#endif

/*

"Undocumented" FPU instructions
===============================

There are certain FPU opcodes that have been considered undocumented
in the
past, although this is not strictly true. In fact these opcodes are
listed
on page A-5 of the 1987 Intel 80286 and 80287 Programmer's Reference
Manual.
However, this document does not assign mnemonics to the opcodes.
Subsequent 
Intel documentation didn't mention these opcodes at all, but most
recently
Intel has obviously chosen to make these opcodes "official" by
including 
them in the PentiumPro opcode list at the end of AP-526
Optimization's
[sic!] 
For Intel's 32-Bit Processors, October 1995. This document for the
first
time assigns mnemonics to these opcodes:

   FSTP1  ST(i)    D9D8...D9DF
   FCOM2  ST(i)    DCD0...DCD7
   FCOMP3 ST(i)    DCD8...DCDF
   FXCH4  ST(i)    DDC8...DDCF
   FCOMP5 ST(i)    DED0...DED7
   FFREEP ST(i)    DFC0...DFC7
   FXCH7  ST(i)    DFC8...DFCF
   FSTP8  ST(i)    DFD0...DFD7
   FSTP9  ST(i)    DFD8...DFDF

These opcodes have been supported on all Intel math coprocessors and
FPUs
since the 287 as well as on all Cyrix and IIT math coprocessors and
FPUs. 
Tests show that the functionality of these opcodes is identical
across the 
486, Pentium, and PentiumPro.

FCOM2 is an alias to FCOM, FCOMP3 and FCOMP5 alias to FCOMP, FXCH4
and FXCH7
alias to FXCH, FSTP8 and FSTP9 alias to FSTP.


FSTP1 ST(i) (D9D8...D9DF)
-------------------------
This opcode differs from the "regular" FSTP opcodes when a stack
fault
(stack
underflow) occurs. In that case, regardless of CW.IM, it does not
set SW.IE,
SW.SF, SW.ES, and SW.BUSY and does not signal an error to the CPU
(does not
raise FERR#). It does not store to the destination register, but it
does pop
the stack.

I contrast the other FSTP opcodes upon encountering a stackfault
(stack
underflow) respond in one of two ways:

  - If CW.IM = 1, they set SW.IE and SW.SF, store INDEFINITE to the
destination
    register and pop the stack.
  - If CW.IM = 0, they set SW.IE, SW,SF, SW,ES, and SW.BUSY, signal
an error
to
    the CPU (raise FERR#) and do not store to the destination
register and
do
    not pop the stack.


FFREEP ST(i) (DFC0...DFC7)
--------------------------

These opcodes behave like a regular FFREE ST(i) followed by a stack
pop. No
exceptions are raised by these opcodes. FFREEP ST(i) can mark up to
two
registers as empty. One is the destination register, the other one
ST(0).
After marking the registers as empty, FFREEP increments SW.TOP.

*/